function RNLTV_denoising_Fig14
% 090332017  synLines332412281
%
%setup the path
curDir=pwd; %Identify current folder

addessFolder = strjoin({curDir,'img_png_NLTV'},filesep);
path(addessFolder,path);

application.name = 'denoising';

ExpFolderName = 'results';

ExpFolderPath = strjoin({curDir,ExpFolderName,application.name},filesep);
if ~exist(ExpFolderPath , 'dir')
    mkdir(ExpFolderPath );
end

fileName_array = {'Fig10' };

nbIter = 600;
radius = 5;
init = 3;

application.data_term = 2;

gama = 0.3;
mu=0.6;
hsigma=0.05;

sigm_array= [0.12 0.14 0.16];
for i_fileName = 1:length(fileName_array)
    fileName = fileName_array{i_fileName};
    
    ExpSubfolderPath = strjoin({ExpFolderPath,fileName},filesep);
    if ~exist( ExpSubfolderPath, 'dir')
        mkdir( ExpSubfolderPath);
    end
    
    polSubFolderPath =strjoin({ExpSubfolderPath,'pol'},filesep);
    if ~exist( polSubFolderPath, 'dir')
        mkdir( polSubFolderPath);
    end
    
    % load in_clean
    load([fileName,'.mat']);
    in_clean = double(in_clean);
    
    for i_sigm = 1:length(sigm_array)
        
        sigm = sigm_array(i_sigm);
        %add noise
        tempImgName = [fileName,...
            '_sg', num2str(sigm)];
        rng(8,'twister');
        in_polluted = in_clean + sigm*randn(size(in_clean));
        if ~exist(polSubFolderPath, 'dir')
            mkdir(polSubFolderPath);
        end
        save(strjoin({polSubFolderPath,...
            [tempImgName,'_in_polluted','.mat']},filesep), 'in_polluted');
        
        lambda = sigm * 1; % application.data_term = 2;
        
        [u,v,energies] = regularized_NLTV(in_polluted,nbIter,radius,mu,...
            lambda,gama, hsigma, init, application);
        psnr = psnr1(u,in_clean)
        
        imgResultNameFolderPath = strjoin({ExpSubfolderPath,...
            tempImgName},filesep);
        
        % save image results
        save([imgResultNameFolderPath '_u_.mat'],'u');
        
    end
end